/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto - Wayland Adapter
*
* \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <aauto/AditEndpointCommon.h>
#include "WaylandInputSource.h"

LOG_DECLARE_CONTEXT(aauto_input);

using namespace adit::aauto;

#ifndef COMP_GIT_VERSION
#define COMP_GIT_VERSION "aauto_r3_d01 or newer"
#endif

namespace adit { namespace aauto {

AditInputSource* WaylandInputSourceCreate(uint8_t inId, MessageRouter* inRouter)
{
    if(inRouter == nullptr)
    {
        LOG_ERROR((aauto_input, "MessageRouter pointer is null"));
        return nullptr;
    }
    
    return new WaylandInputSource(inId, inRouter);
}

/*
 * In case the library is linked at compile time it is more convenient to call unique functions
 * rather than the generic plug-in versions.
 */

void WaylandEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    LOG_REGISTER_CONTEXT(aauto_input, "INP", "AAUTO input-endpoint");
    LOGD_DEBUG((aauto_input, "aauto-wl-touch git tag: %s", COMP_GIT_VERSION));

    if (inFactoryRegisterFn != nullptr)
    {
        // it is not required to use the factory
        inFactoryRegisterFn("WaylandInputSource", FactoryInputSource,
                            (CreatorFn)WaylandInputSourceCreate);
    }
}

void WaylandExitPoint()
{
    LOG_UNREGISTER_CONTEXT(aauto_input);
}

} } // namespace adit { namespace aauto {

extern "C" void aauto_LibraryEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    WaylandEntryPoint(inFactoryRegisterFn);
}

extern "C" void aauto_LibraryExitPoint()
{
    WaylandExitPoint();
}
